function SeparatedPARAFACplots(Factors)
    %% Mode 1 - All components together
    pMainFigure = figure(...
        'Color',[0.9 0.9 0.9],...
        'MenuBar','none',...
        'Toolbar','Figure',...
        'NumberTitle','Off',...
        'Name','Mode 1 - All components');
    
    %Clean up the Toolbar, removing things we don't need
    rmv = findall(pMainFigure,'ToolTipString','New Figure');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Open File');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Link Plot');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Legend');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Rotate 3D');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Data Cursor');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Colorbar');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Brush/Select Data');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Hide Plot Tools');
    set(rmv,'Visible','Off')
    
    mode1=real(Factors{1, 1});
    h=plot(mode1);
    set(gca,'xdir','reverse');
    axis('tight');
    % set(h,'LineWidth',1);
    % set(gca,'LineWidth',1);
    ylim([(min(min(mode1))-0.1*max(max(mode1))) max(max(mode1))*1.1]);
    title({'','Spectrum mode',''},'FontSize',12, 'FontWeight','bold');
    xlabel('Chemical shift / ppm','FontSize',10, 'FontWeight','bold');
    ylabel('Intensity','FontSize',10, 'FontWeight','bold');
    
    
    % Mode 1 - All components separate
    pMainFigure=figure('Color',[0.9 0.9 0.9],...
        'MenuBar','none',...
        'Toolbar','Figure',...
        'NumberTitle','Off',...
        'Name','Mode 1 - Separate components');
    
    %Clean up the Toolbar, removing things we don't need
    rmv = findall(pMainFigure,'ToolTipString','New Figure');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Open File');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Link Plot');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Legend');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Rotate 3D');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Data Cursor');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Colorbar');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Brush/Select Data');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Hide Plot Tools');
    set(rmv,'Visible','Off')
    
    ax=zeros(1,3);
    for k=1:3
        ax(k)=subplot(3,1,k);
        %h=
        plot(mode1(:,k));
        set(gca,'xdir','reverse');
        ylabel('Intensity','FontSize',10, 'FontWeight','bold');
        if k==1
            title({'','Spectrum mode',''},'FontSize',12, 'FontWeight','bold')
        end
        if k==3
            xlabel('Chemical shift / ppm','FontSize',10, 'FontWeight','bold');
        end
    end
    linkaxes(ax,'x');
    
    
    %% Mode2 - All components
    pMainFigure=figure('Color',[0.9 0.9 0.9],...
        'MenuBar','none',...
        'Toolbar','Figure',...
        'NumberTitle','Off',...
        'Name','Mode 2 - All components');
    
    %Clean up the Toolbar, removing things we don't need
    rmv = findall(pMainFigure,'ToolTipString','New Figure');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Open File');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Link Plot');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Legend');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Rotate 3D');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Data Cursor');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Colorbar');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Brush/Select Data');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Hide Plot Tools');
    set(rmv,'Visible','Off')
    
    mode2=Factors{1, 1};
    h=plot(mode2, '-*');
    axis('tight')
    set(h,'LineWidth',1)
    set(gca,'LineWidth',1)
    ylim([(min(min(mode2))-0.1*max(max(mode2))) max(max(mode2))*1.1])
    title({'','Mode 2',''},'FontSize',12, 'FontWeight','bold')
    xlabel('Experiment','FontSize',10, 'FontWeight','bold')
    ylabel('Intensity','FontSize',10, 'FontWeight','bold')
    
    % Mode 2 - Separate components
    pMainFigure=figure('Color',[0.9 0.9 0.9],...
        'MenuBar','none',...
        'Toolbar','Figure',...
        'NumberTitle','Off',...
        'Name','Mode 2 - Separate components');
    
    %Clean up the Toolbar, removing things we don't need
    rmv = findall(pMainFigure,'ToolTipString','New Figure');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Open File');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Link Plot');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Legend');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Rotate 3D');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Data Cursor');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Colorbar');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Brush/Select Data');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Hide Plot Tools');
    set(rmv,'Visible','Off')
    
    for k=1:3
        ax(k)=subplot(3,1,k);
        %h=
        plot(mode2(:,k), '-*');
        ylabel('Intensity','FontSize',10, 'FontWeight','bold')
        if k==1
            title({'','Mode 2',''},'FontSize',12, 'FontWeight','bold')
        end
        if k==3
            xlabel('Experiment','FontSize',10, 'FontWeight','bold');
        end
    end
    
    linkaxes(ax,'x');
    
    
    % Mode 3 - All components
    pMainFigure=figure('Color',[0.9 0.9 0.9],...
        'MenuBar','none',...
        'Toolbar','Figure',...
        'NumberTitle','Off',...
        'Name','Mode 3 - All components');
    
    %Clean up the Toolbar, removing things we don't need
    rmv = findall(pMainFigure,'ToolTipString','New Figure');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Open File');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Link Plot');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Legend');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Rotate 3D');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Data Cursor');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Colorbar');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Brush/Select Data');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Hide Plot Tools');
    set(rmv,'Visible','Off')
    
    mode3=Factors{3};
    h=plot(mode3, '-*');
    axis('tight')
    set(h,'LineWidth',1)
    set(gca,'LineWidth',1)
    ylim([(min(min(mode3))-0.1*max(max(mode3))) max(max(mode3))*1.1])
    title({'','Mode 3',''},'FontSize',12, 'FontWeight','bold')
    xlabel('Experiment','FontSize',10, 'FontWeight','bold')
    ylabel('Intensity','FontSize',10, 'FontWeight','bold')
    
    
    % Mode3  - Separate components
    pMainFigure=figure('Color',[0.9 0.9 0.9],...
        'MenuBar','none',...
        'Toolbar','Figure',...
        'NumberTitle','Off',...
        'Name','Mode 3 - Separate components');
    
    %Clean up the Toolbar, removing things we don't need
    rmv = findall(pMainFigure,'ToolTipString','New Figure');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Open File');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Link Plot');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Legend');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Rotate 3D');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Data Cursor');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Insert Colorbar');
    set(rmv,'Visible','Off')
    %                 rmv = findall(pMainFigure,'ToolTipString','Edit Plot');
    %                 set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Brush/Select Data');
    set(rmv,'Visible','Off')
    rmv = findall(pMainFigure,'ToolTipString','Hide Plot Tools');
    set(rmv,'Visible','Off')
    
    for k=1:3
        ax(k)=subplot(3,1,k);
        %h=
        plot(mode3(:,k), '-*');
        ylabel('Intensity','FontSize',10, 'FontWeight','bold')
        if k==1
            title({'','Mode 3',''},'FontSize',12, 'FontWeight','bold')
        end
        if k==3
            xlabel('Experiment','FontSize',10, 'FontWeight','bold');
        end
    end
    linkaxes(ax,'x');
end

